/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.FromTableInterface;
import com.mckoi.database.interpret.TableExpressionFromSet;
import com.mckoi.database.interpret.TableSelectExpression;

public class FromTableSubQuerySource
implements FromTableInterface {
    private TableSelectExpression table_expression;
    private TableExpressionFromSet from_set;
    private TableName end_table_name;
    private String unique_key;
    private Variable[] vars;
    private boolean case_insensitive = false;

    public FromTableSubQuerySource(DatabaseConnection connection, String unique_key, TableSelectExpression table_expression, TableExpressionFromSet from_set, TableName aliased_table_name) {
        this.unique_key = unique_key;
        this.table_expression = table_expression;
        this.from_set = from_set;
        this.end_table_name = aliased_table_name;
        this.case_insensitive = connection.isInCaseInsensitiveMode();
    }

    TableSelectExpression getTableExpression() {
        return this.table_expression;
    }

    TableExpressionFromSet getFromSet() {
        return this.from_set;
    }

    TableName getAliasedName() {
        return this.end_table_name;
    }

    private void ensureVarList() {
        if (this.vars == null) {
            this.vars = this.from_set.generateResolvedVariableList();
            if (this.end_table_name != null) {
                for (int i = 0; i < this.vars.length; ++i) {
                    this.vars[i].setTableName(this.end_table_name);
                }
            }
        }
    }

    public String getUniqueKey() {
        return this.unique_key;
    }

    public void setCaseInsensitive(boolean status) {
        this.case_insensitive = status;
    }

    private boolean stringCompare(String str1, String str2) {
        if (!this.case_insensitive) {
            return str1.equals(str2);
        }
        return str1.equalsIgnoreCase(str2);
    }

    private boolean matchesVar(Variable v, String catalog, String schema, String table, String column) {
        TableName tn = v.getTableName();
        String cn = v.getName();
        if (column == null) {
            return true;
        }
        if (!this.stringCompare(cn, column)) {
            return false;
        }
        if (table == null) {
            return true;
        }
        if (tn == null) {
            return false;
        }
        String tname = tn.getName();
        if (tname != null && !this.stringCompare(tname, table)) {
            return false;
        }
        if (schema == null) {
            return true;
        }
        String sname = tn.getSchema();
        return sname == null || this.stringCompare(sname, schema);
    }

    public String getUniqueName() {
        return this.getUniqueKey();
    }

    public boolean matchesReference(String catalog, String schema, String table) {
        if (schema == null && table == null) {
            return true;
        }
        if (this.end_table_name != null) {
            String ts = this.end_table_name.getSchema();
            String tt = this.end_table_name.getName();
            if (schema == null ? this.stringCompare(tt, table) : this.stringCompare(tt, table) && this.stringCompare(ts, schema)) {
                return true;
            }
        }
        return false;
    }

    public int resolveColumnCount(String catalog, String schema, String table, String column) {
        this.ensureVarList();
        if (catalog == null && schema == null && table == null && column == null) {
            return this.vars.length;
        }
        int matched_count = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            Variable v = this.vars[i];
            if (!this.matchesVar(v, catalog, schema, table, column)) continue;
            ++matched_count;
        }
        return matched_count;
    }

    public Variable resolveColumn(String catalog, String schema, String table, String column) {
        this.ensureVarList();
        for (int i = 0; i < this.vars.length; ++i) {
            Variable v = this.vars[i];
            if (!this.matchesVar(v, catalog, schema, table, column)) continue;
            return v;
        }
        throw new Error("Couldn't resolve to a column.");
    }

    public Variable[] allColumns() {
        this.ensureVarList();
        return this.vars;
    }
}

